<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:kedu="http://www.zus.pl/2015/KED_ZLA_1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://pue.zus.pl/rd/ZUS_ZLA/8/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">

    <xsl:template match="/">
        <xsl:call-template name="ZLA">
            <xsl:with-param name="root" select="//wnio:TrescDokumentu"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="ZLA">
        <xsl:param name="root"></xsl:param>
        <html>
            <head>
                <title>ZUS ZLA (Formularz elektroniczny) - Zakład Ubezpieczeń Społecznych</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"></meta>
            </head>
            <body style="text-align: center; font-family: Arial; ">
                <div style="width: 880px; height: 1280px; position: relative; border: 1px solid black; margin-left: auto; margin-right: auto; text-align: left; overflow: hidden; margin-top: 15px;">
                    <div style="width: 870px; height: 26px; left: 4px; top: 0px; position: absolute; ">
                        <div style="width: 545px; height: 24px; left: 322px; top: 0px; text-align: right; position: absolute; color:#000000; font-size:12px; font-size:20px; font-weight:bold;">ZUS ZLA</div>
                        <div style="width: 300px; height: 14px; left: 3px; top: 8px; position: absolute; color:#000000; font-size:12px; font-weight:normal;" >ZAKŁAD &#xa0;UBEZPIECZEŃ &#xa0;SPOŁECZNYCH</div>
                        <div style="width: 100%; left: 0px; top: 25px; border-top: 1px solid black; position: absolute; ">
                            <span></span>
                        </div>
                    </div>
                    <div style="height: 14px; left: 126px; top: 35px; position: absolute; color:#000000; font-size:12px; font-weight:bold;">Wypełnić tylko pola jasne w wyznaczonych kratkach dużymi drukowanymi literami czarnym lub niebieskim kolorem</div>
                    <div style="width: 87px; height: 52px; left: 6px; top: 54px; border-style: solid; border-width: 2px; position: absolute; background-color:#ffffff; background-color: #FCD2BC;
				border-color: #F05C31; background-color: #FCD2BC; border-color: #F05C31;" >
                        <div style="width: 100%; text-align: center; position: absolute; top: 18px; color:#000000; font-size:12px; font-weight:bold;" >ZUS ZLA</div>
                    </div>
                    <div style="width: 74px; height: 52px; left: 91px; top: 54px; border-style: solid; border-width: 2px; position: absolute; background-color:#ffffff; background-color: #FCD2BC; border-color: #F05C31;">
                        <div style="width: 49px; left: 10px; top: 5px; position: absolute; color:#000000; font-size:12px;" >Seria</div>
                        <div style="width: 49px; height: 25px; left: 10px; top: 19px; position: absolute; overflow: hidden; display: block; border: 1px solid black;  color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:I/kedu:p1/kedu:p1"></xsl:value-of>
                            </span>
                        </div>
                    </div>
                    <div style="width: 193px; height: 52px; left: 163px; top: 54px; border-style: solid; border-width: 2px; position: absolute; background-color:#ffffff;	background-color: #FCD2BC; border-color: #F05C31;">
                        <div style="width: 111px; left: 10px; top: 5px; position: absolute; color:#000000; font-size:12px;">Nr</div>
                        <div style="width: 169px; height: 25px; left: 10px; top: 19px; position: absolute; overflow: hidden; display: block; border: 1px solid black;  color:#000000; font-size:18px;" >
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:I/kedu:p1/kedu:p2"></xsl:value-of>
                            </span>
                        </div>
                    </div>
                    <div style="width: 86px; height: 52px; left: 354px; top: 54px; border-style: solid; border-width: 2px; position: absolute; background-color:#ffffff; background-color: #FCD2BC; border-color: #F05C31;">
                        <div style="width: 100%; text-align: center; position: absolute; margin-top: 18px; color:#000000; font-size:12px;">
                            <xsl:value-of select="$root/kedu:I/kedu:p2"/>
                        </div>
                    </div>
                    <div style="width: 196px; height: 52px; left: 438px; top: 54px; border-style: solid; border-width: 2px; position: absolute; background-color:#ffffff;	background-color: #FCD2BC; border-color: #F05C31;">
                        <div style="width: 100%; text-align: center; position: absolute; top: 15px; color:#000000; font-size:12px; font-size:10px; font-family:arial; font-weight:normal;" >
                            POUFNE
                            <br></br>
                            DRUK ŚCISŁEGO ZARACHOWANIA
                        </div>
                    </div>
                    <div style="width: 239px; height: 52px; left: 632px; top: 54px; border-style: solid; border-width: 2px; position: absolute; background-color:#ffffff;	background-color: #FCD2BC; border-color: #F05C31;">
                        <div style="width: 100%; text-align: center; position: absolute; top: 18px; color:#000000; font-size:12px; font-weight:bold;" >ZAŚWIADCZENIE LEKARSKIE</div>
                    </div>
                    <div style="width: 867px; height: 156px; left: 6px; top: 115px; border-style: solid; border-width: 1px; position: absolute; background-color:#ffffff;">
                        <div style="width: 860px; height: 14px; left: 0px; top: 5px; position: absolute; color:#000000; font-size:12px; font-weight:bold;">DANE IDENTYFIKACYJNE UBEZPIECZONEGO</div>
                        <div style="left: 0px; top: 19px; position: absolute; color:#000000; font-size:12px;" >01. PESEL ubezpieczonego</div>
                        <div style="width: 265px; height: 25px; left: 0px; top: 33px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:II/kedu:p1"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 336px; top: 19px; position: absolute; color:#000000; font-size:12px;">02. Imię pierwsze ubezpieczonego</div>
                        <div style="width: 530px; height: 25px; left: 336px; top: 33px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:II/kedu:p2"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 0px; top: 64px; position: absolute; color:#000000; font-size:12px;">03. Nazwisko ubezpieczonego</div>
                        <div style="width: 745px; height: 25px; left: 0px; top: 78px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:II/kedu:p3"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 768px; top: 63px; position: absolute; color:#000000; font-size:12px;">
                            04. Ubezpieczony
                            <br></br>
                            w (1)
                        </div>
                        <div style="width: 25px; height: 25px; left: 816px; top: 78px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:II/kedu:p4"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 0px; top: 109px; position: absolute; color:#000000; font-size:12px;">05. Seria i numer paszportu (2)</div>
                        <div style="width: 361px; height: 25px; left: 0px; top: 123px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:II/kedu:p5"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 408px; top: 109px; position: absolute; color:#000000; font-size:12px;" >06. Data urodzenia ubezpieczonego (dd / mm / rrrr) (2)</div>
                        <div style="width: 193px; height: 25px; left: 408px; top: 123px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000;	font-size:18px;	border-style:solid;	background-color:#ffffff;">
                            <span></span>
                            <span style="padding-left:8px ; padding-top:2px; display: block; font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:II/kedu:p6 != ''">
                                    <xsl:value-of select="substring($root/kedu:II/kedu:p6, 9, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:II/kedu:p6, 6, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:II/kedu:p6, 1, 4)"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>
                    </div>
                    <div style="width: 867px; height: 578px; left: 6px; top: 275px; border-style: solid; border-width: 1px; position: absolute; background-color:#ffffff;">
                        <div style="width: 860px; height: 14px; left: 0px; top: 5px; position: absolute; color:#000000; font-size:12px; font-weight:bold;" >DANE ADRESOWE UBEZPIECZONEGO (3)</div>

                        <div style="left: 0px; top: 19px; position: absolute; color:#000000; font-size:12px;" >07. Państwo</div>
                        <div style="width: 145px; height: 25px; left: 0px; top: 33px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:8px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:III/kedu:p6!= '' and $root/kedu:III/kedu:p6!= 'PL'">
									<xsl:value-of select="$root/kedu:III/kedu:p7"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>


                        <div style="left: 168px; top: 19px; position: absolute; color:#000000; font-size:12px;" >08. Kod pocztowy</div>
                        <div style="width: 145px; height: 25px; left: 168px; top: 33px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:8px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">

								<xsl:choose>
									<xsl:when test="$root/kedu:III/kedu:p6!= '' and $root/kedu:III/kedu:p6!= 'PL'">
										<xsl:value-of select="$root/kedu:III/kedu:p8"></xsl:value-of>
									</xsl:when>
									<xsl:when test="$root/kedu:III/kedu:p1!= ''">
										<xsl:value-of select="substring($root/kedu:III/kedu:p1, 1, 2)"></xsl:value-of>
										-
										<xsl:value-of select="substring($root/kedu:III/kedu:p1, 3, 4)"></xsl:value-of>
									</xsl:when>
									<xsl:otherwise>
									</xsl:otherwise>

								</xsl:choose>
                            </span>
                        </div>
						
                        <div style="left: 340px; top: 19px; position: absolute; color:#000000; font-size:12px;" >09. Miejscowość</div>
                        <div style="width: 500px; height: 25px; left: 340px; top: 33px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:III/kedu:p2"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 0px; top: 64px; position: absolute; color:#000000; font-size:12px;" >10. Ulica</div>
                        <div style="width: 721px; height: 25px; left: 0px; top: 77px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:III/kedu:p3"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 0px; top: 108px; position: absolute; color:#000000; font-size:12px;" >11. Numer domu</div>
                        <div style="width: 168px; height: 25px; left: 0px; top: 121px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:III/kedu:p4"></xsl:value-of>
                            </span>
                        </div>
                        <div style="height: 14px; left: 192px; top: 108px; position: absolute; color:#000000; font-size:12px;" >12. Numer lokalu</div>
                        <div style="width: 168px; height: 25px; left: 192px; top: 121px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:III/kedu:p5"></xsl:value-of>
                            </span>
                        </div>
                        <div style="width:868px; left: -1px; top: 157px; border-top: 1px solid black; position: absolute; ">
                            <span></span>
                        </div>
                        <div style="width: 860px; height: 14px; left: 0px; top: 163px; position: absolute; color:#000000; font-size:12px; font-weight:bold;">DANE O NIEZDOLNOŚCI DO PRACY</div>
                        <div style="height: 30px; left: 0px; top: 177px; position: absolute; color:#000000; font-size:12px;" >
                            13. Niezdolność do pracy od
                            <br></br>
                            (dd / mm / rrrr)
                        </div>
                        <div style="width: 193px; height: 25px; left: 0px; top: 204px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px; border-style:solid; background-color:#ffffff;">
                            <span></span>
                            <span style="padding-left:8px ; padding-top:2px; display: block; font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:IV/kedu:p1/kedu:p1 != ''">
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p1/kedu:p1, 9, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p1/kedu:p1, 6, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p1/kedu:p1, 1, 4)"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>
                        <div style="height: 30px; left: 216px; top: 177px; position: absolute; color:#000000; font-size:12px;" >
                            14. Niezdolność do pracy do
                            <br></br>
                            (dd / mm / rrrr)
                        </div>
                        <div style="width: 193px; height: 25px; left: 216px; top: 204px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000;	font-size:18px;	border-style:solid;	background-color:#ffffff;">
                            <span></span>
                            <span style="padding-left:8px ; padding-top:2px; display: block; font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:IV/kedu:p1/kedu:p2 != ''">
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p1/kedu:p2, 9, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p1/kedu:p2, 6, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p1/kedu:p2, 1, 4)"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>
                        <div style="width: 130px; height: 30px; left: 456px; top: 177px; position: absolute; color:#000000; font-size:12px;" >
                            15. Pobyt w szpitalu od
                            <br></br>
                            (dd / mm / rrrr)
                        </div>
                        <div style="width: 193px; height: 25px; left: 456px; top: 204px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px; border-style:solid; background-color:#ffffff;">
                            <span></span>
                            <span style="padding-left:8px ; padding-top:2px; display: block; font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:IV/kedu:p2/kedu:p1 != ''">
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p2/kedu:p1, 9, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p2/kedu:p1, 6, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p2/kedu:p1, 1, 4)"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>
                        <div style="width: 130px; height: 30px; left: 672px; top: 177px; position: absolute; color:#000000; font-size:12px;">
                            16. Pobyt w szpitalu do
                            <br></br>
                            (dd / mm / rrrr)
                        </div>
                        <div style="width: 194px; height: 25px; left: 672px; top: 204px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;	border-style:solid;	background-color:#ffffff;">
                            <span></span>
                            <span style="padding-left:8px ; padding-top:2px; display: block; font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:IV/kedu:p2/kedu:p2 != ''">
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p2/kedu:p2, 9, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p2/kedu:p2, 6, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p2/kedu:p2, 1, 4)"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>
                        <div style="width: 95px; height: 30px; left: 0px; top: 235px; position: absolute; color:#000000; font-size:12px;" >
                            17. Wskazania
                            <br></br>
                            lekarskie (4)
                        </div>
                        <div style="width: 25px; height: 25px; left: 0px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:IV/kedu:p3"></xsl:value-of>
                            </span>
                        </div>
                        <div style="height: 14px; left: 120px; top: 249px; position: absolute; color:#000000; font-size:12px;" >18. Kod(y) (5)</div>
                        <div style="width: 25px; height: 25px; left: 120px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:IV/kedu:p4"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 152px; top: 270px; position: absolute; color:#000000; font-size:12px; font-weight:normal;" >/</div>
                        <div style="width: 25px; height: 25px; left: 168px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:IV/kedu:p5"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 200px; top: 270px; position: absolute; color:#000000; font-size:12px; font-weight:normal;" >/</div>
                        <div style="width: 25px; height: 25px; left: 216px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:IV/kedu:p6"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 248px; top: 270px; position: absolute; color:#000000; font-size:12px; font-weight:normal;" >/</div>
                        <div style="width: 25px; height: 25px; left: 264px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:IV/kedu:p7"></xsl:value-of>
                            </span>
                        </div>
                        <div style="width: 145px; height: 28px; left: 336px; top: 235px; position: absolute; color:#000000; font-size:12px;" >
                            19. Numer statystyczny
                            <br></br>
                            choroby
                        </div>
                        <div style="width: 72px; height: 25px; left: 336px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white;	color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:IV/kedu:p8"></xsl:value-of>
                            </span>
                        </div>
                        <div style="height: 28px; left: 504px; top: 235px; position: absolute; color:#000000; font-size:12px;">
                            20. Kod pokrewieństwa
                            <br></br>
                            osoby pod opieką (6)
                        </div>
                        <div style="width: 25px; height: 25px; left: 504px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:IV/kedu:p9/kedu:p1"></xsl:value-of>
                            </span>
                        </div>
                        <div style="height: 28px; left: 648px; top: 235px; position: absolute; color:#000000; font-size:12px;">
                            21. Data urodzenia osoby pozostającej
                            <br></br>
                            pod opieką (dd / mm / rrrr)
                        </div>
                        <div style="width: 193px; height: 25px; left: 648px; top: 263px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;	border-style:solid;	background-color:#ffffff;">
                            <span></span>
                            <span style="padding-left:8px ; padding-top:2px; display: block; font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:IV/kedu:p9/kedu:p2 != ''">
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p9/kedu:p2, 9, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p9/kedu:p2, 6, 2)"></xsl:value-of>
                                    /
                                    <xsl:value-of select="substring($root/kedu:IV/kedu:p9/kedu:p2, 1, 4)"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>
                        <div style="width: 868px; left: -1px; top: 299px; border-top: 1px solid black; position: absolute; ">
                            <span></span>
                        </div>
                        <div style="width: 409px; height: 14px; left: 0px; top: 304px; position: absolute; color:#000000; font-size:12px; font-weight:bold;" >DANE PŁATNIKA</div>
                        <div style="width: 850px; left: 0px; top: 318px; position: absolute; color:#000000; font-size:12px;" >22. Rodzaj identyfikatora płatnika (7)</div>
                        <div style="width: 25px; height: 25px; left: 0px; top: 332px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:V/kedu:p1"></xsl:value-of>
                            </span>
                        </div>
                        <div style="width: 850px; left: 240px; top: 318px; position: absolute; color:#000000; font-size:12px;">23. Identyfikator płatnika (8)</div>
                        <div style="width: 375px; height: 25px; left: 240px; top: 332px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:V/kedu:p2"></xsl:value-of>
                            </span>
                        </div>
                        <div style="width: 868px; left: -1px; top: 368px; border-top: 1px solid black; position: absolute; ">
                            <span></span>
                        </div>
                        <div style="width: 860px; height: 14px; left: 0px; top: 373px; position: absolute; color:#000000; font-size:12px; font-weight: bold;" >PODMIOT WYKONUJĄCY DZIAŁALNOŚĆ LECZNICZĄ</div>
                        <div style="left: 0px; top: 395px; position: absolute; color:#000000; font-size:12px;" >24. Nazwa skrócona</div>
                        <div style="width: 745px; height: 25px; left: 0px; top: 409px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:call-template name="redukcjaCzcionki">
                                    <xsl:with-param name="tekst" select="$root/kedu:VI/kedu:p1"></xsl:with-param>
                                    <xsl:with-param name="bazowyRozmiarCzcionki" select="12"></xsl:with-param>
                                    <xsl:with-param name="dlugoscPolaWPikselach" select="745"></xsl:with-param>
                                </xsl:call-template>
                            </span>
                        </div>
                        <div style="left: 0px; top: 440px; position: absolute; color:#000000; font-size:12px;">25. Kod pocztowy</div>
                        <div style="width: 145px; height: 25px; left: 0px; top: 453px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:if test="$root/kedu:VI/kedu:p3!= ''">
                                    <xsl:value-of select="substring($root/kedu:VI/kedu:p2, 1, 2)"></xsl:value-of>
                                    -
                                    <xsl:value-of select="substring($root/kedu:VI/kedu:p2, 3, 4)"></xsl:value-of>
                                </xsl:if>
                            </span>
                        </div>
                        <div style="left: 192px; top: 440px; position: absolute; color:#000000; font-size:12px;">26. Miejscowość</div>
                        <div style="width: 625px; height: 25px; left: 192px; top: 453px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:VI/kedu:p3"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 0px; top: 484px; position: absolute; color:#000000; font-size:12px;">27. Ulica</div>
                        <div style="width: 721px; height: 25px; left: 0px; top: 497px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:call-template name="redukcjaCzcionki">
                                    <xsl:with-param name="tekst" select="$root/kedu:VI/kedu:p4"></xsl:with-param>
                                    <xsl:with-param name="bazowyRozmiarCzcionki" select="12"></xsl:with-param>
                                    <xsl:with-param name="dlugoscPolaWPikselach" select="721"></xsl:with-param>
                                </xsl:call-template>
                            </span>
                        </div>
                        <div style="left: 0px; top: 528px; position: absolute; color:#000000; font-size:12px;" >28. Numer domu</div>
                        <div style="width: 168px; height: 25px; left: 0px; top: 541px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:call-template name="redukcjaCzcionki">
                                    <xsl:with-param name="tekst" select="$root/kedu:VI/kedu:p5"></xsl:with-param>
                                    <xsl:with-param name="bazowyRozmiarCzcionki" select="12"></xsl:with-param>
                                    <xsl:with-param name="dlugoscPolaWPikselach" select="168"></xsl:with-param>
                                </xsl:call-template>
                            </span>
                        </div>
                        <div style="left: 192px; top: 528px; position: absolute; color:#000000; font-size:12px;">29. Numer lokalu</div>
                        <div style="width: 168px; height: 25px; left: 192px; top: 541px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:call-template name="redukcjaCzcionki">
                                    <xsl:with-param name="tekst" select="$root/kedu:VI/kedu:p6"></xsl:with-param>
                                    <xsl:with-param name="bazowyRozmiarCzcionki" select="12"></xsl:with-param>
                                    <xsl:with-param name="dlugoscPolaWPikselach" select="168"></xsl:with-param>
                                </xsl:call-template>
                            </span>
                        </div>
                    </div>
                    <div style="width: 867px; height: 115px; left: 6px; top: 857px; border-style: solid; border-width: 1px; position: absolute; background-color:#ffffff; background-color: #FCD2BC; border-color: #F05C31;">
                        <div style="width: 251px; height: 14px; left: 0px; top: 5px; position: absolute; color:#000000; font-size:12px; font-weight:bold; ">DANE LEKARZA</div>
                        <div style="left: 0px; top: 19px; position: absolute; color:#000000; font-size:12px;" >30. Identyfikator lekarza</div>
                        <div style="width: 168px; height: 25px; left: 0px; top: 33px; position: absolute; overflow: hidden; display: block; border: 1px solid black; color:#000000;	color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:VII/kedu:p1"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 216px; top: 19px; position: absolute; color:#000000; font-size:12px;">31. Imię lekarza</div>
                        <div style="width: 529px; height: 25px; left: 216px; top: 33px; position: absolute; overflow: hidden; display: block; border: 1px solid black; color:#000000; font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:VII/kedu:p2"></xsl:value-of>
                            </span>
                        </div>
                        <div style="left: 0px; top: 64px; position: absolute; color:#000000; font-size:12px;">32. Nazwisko lekarza</div>
                        <div style="width: 745px; height: 25px; left: 0px; top: 78px; position: absolute; overflow: hidden; display: block; border: 1px solid black; color:#000000;	font-size:18px;">
                            <span style="padding-left:5px ; padding-top:2px; display: block;font-family: Times; font-size: 16px;">
                                <xsl:value-of select="$root/kedu:VII/kedu:p3"></xsl:value-of>
                            </span>
                        </div>
                    </div>
                    <div style="width: 314px; left: 7px; top: 1001px; position: absolute; color:#000000; font-size:12px;" >33. Data wystawienia dokumentu (dd / mm / rrrr)</div>
                    <div style="width: 193px; height: 25px; left: 7px; top: 1015px; position: absolute; overflow: hidden; display: block; border: 1px solid black; background-color: white; color:#000000; font-size:18px; border-style:solid; background-color:#ffffff;">
                        <span></span>
                        <span style="padding-left:8px ; padding-top:2px; display: block; font-family: Times; font-size: 16px;">
                            <xsl:if test="$root/kedu:VIII/kedu:p1 != ''">
                                <xsl:value-of select="substring($root/kedu:VIII/kedu:p1, 9, 2)"></xsl:value-of>
                                /
                                <xsl:value-of select="substring($root/kedu:VIII/kedu:p1, 6, 2)"></xsl:value-of>
                                /
                                <xsl:value-of select="substring($root/kedu:VIII/kedu:p1, 1, 4)"></xsl:value-of>
                            </xsl:if>
                        </span>
                    </div>
                    <div style="width: 289px; height: 126px; left: 44px; top: 1059px; border-style: solid; border-width: 2px; border-color: #F05C31; position: absolute; background-color:#ffffff;">
                        <div style="width: 280px; height: 30px; left: 4px; top: 4px; position: absolute; " class="SofRichText">
                            <span style="font-size: 12px;" >34. Podpis i pieczęć lekarza, lekarza dentysty, <br/><span style="margin-left: 19px;">starszego felczera, felczera, asystenta medycznego</span></span>
                        </div>
                    </div>
                    <div style="width: 482px; height: 195px; left: 391px; top: 1005px; border-style: solid; border-width: 1px; position: absolute; background-color:#ffffff; background-color: #FCD2BC; border-color: #F05C31;">
                        <div style="width: 470px; height: 205px; left: 3px; top: 6px; position: absolute; " class="SofRichText">
                            <div style="font-size: 12px; font-weight: normal; line-height: 14px;" >
                                (1) ZUS - wpisać 1 / KRUS - 2 / innym w Polsce - 3 / innym państwie - 4 <br/>
                                (2) Wypełnić tylko w przypadku, gdy nie nadano PESEL<br/>
                                (3) Adres pobytu w okresie trwania niezdolności do pracy<br/>
                                (4) Chory powinien leżeć - wpisać 1 / chory może chodzić - 2<br/>
                                (5) Wpisać odpowiedni kod: A, B, C, D, E<br/>
                                (6) Jeśli dziecko - wpisać 1<br/>
                                <span style="margin-left: 17px;">małżonek, rodzice, ojczym, macocha, rodzic dziecka, teściowie, dziadkowie, wnuki, rodzeństwo - 2</span><br/>
                                <span style="margin-left: 17px;">inne osoby - 3</span><br/>
                                (7) NIP - wpisać 1 / PESEL - 2 / seria i numer paszportu - 3<br/>
                                (8) Należy wpisać (bez kresek) NIP lub PESEL, lub serię i numer paszportu płatnika<br/>
                                <span style="margin-left: 17px;">składek, jeżeli nie ma obowiązku posługiwać się NIP i nie nadano PESEL</span><br/>
                                (9) Wpisywać bez kresek<br/>
                            </div>
                            <span></span>
                        </div>
                    </div>
                    <div style="width: 870px; height: 16px; left: 4px; top: 1223px; position: absolute; ">
                        <span style="width: 400px; height: 14px; left: 11px; top: 3px; text-align: left; position: absolute; color:#000000; font-size:12px; font-family:verdana;" ></span>
                        <div style="width: 400px; height: 14px; left: 459px; top: 33px; text-align: right; position: absolute; color:#000000; font-size:11px; font-family:verdana;" >strona: 1/1</div>
                        <div style="width: 100%; left: 0px; top: 30px; border-top: 1px solid black; position: absolute;font-size:10px; font-family:verdana; ">
                            <span style="width:90%;word-wrap:break-word;display:inline-block;">
                                <xsl:if test="$root/kedu:informacja !=''">

                                    <xsl:value-of select="$root/kedu:informacja"/>

                                </xsl:if>

                            </span>
                        </div>
                    </div>
                </div>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="redukcjaCzcionki">
        <xsl:param name="tekst"></xsl:param>
        <xsl:param name="bazowyRozmiarCzcionki"></xsl:param>
        <xsl:param name="dlugoscPolaWPikselach"></xsl:param>
        <xsl:variable name="dlugoscTekstuWPikselach">
            <!-- chodzi o makstylana dlugosc - przypadek kiedy caly tekst skladal sie z liter 'W' -->
            <xsl:value-of select="string-length($tekst) * $bazowyRozmiarCzcionki"></xsl:value-of>
        </xsl:variable>
        <xsl:variable name="roznicaDlugosciTekstuIPolaWPikselach">
            <xsl:value-of select="$dlugoscTekstuWPikselach - $dlugoscPolaWPikselach"></xsl:value-of>
        </xsl:variable>
        <xsl:variable name="docelowyRozmiarCzcionki">
            <xsl:choose>
                <xsl:when test="$roznicaDlugosciTekstuIPolaWPikselach &lt; 0">100</xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="procentOJakiZmniejszamyCzcionke">
                        <xsl:value-of select="($roznicaDlugosciTekstuIPolaWPikselach div $dlugoscTekstuWPikselach)*100"></xsl:value-of>
                    </xsl:variable>
                    <xsl:value-of select="floor(100 - $procentOJakiZmniejszamyCzcionke)"></xsl:value-of>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <span>
            <xsl:attribute name="style">
                font-size:
                <xsl:value-of select="$docelowyRozmiarCzcionki"></xsl:value-of>
                %
            </xsl:attribute>
            <xsl:value-of select="$tekst"></xsl:value-of>
        </span>
    </xsl:template>
    <xsl:template name="linia">
        <xsl:param name="tekst"></xsl:param>
        <xsl:choose>
            <xsl:when test="contains($tekst,'&#xA;')">
                <xsl:call-template name="spacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="substring-before($tekst,'&#xA;')"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
                <br></br>
                <xsl:call-template name="linia">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="substring-after($tekst,'&#xA;')"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="spacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="$tekst"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="spacja">
        <xsl:param name="tekst"></xsl:param>
        <xsl:choose>
            <xsl:when test="contains($tekst,' ')">
                <xsl:call-template name="tabulacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="substring-before($tekst,' ')"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
                &#xa0;​
                <xsl:call-template name="spacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="substring-after($tekst,' ')"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="tabulacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="$tekst"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="tabulacja">
        <xsl:param name="tekst"></xsl:param>
        <xsl:choose>
            <xsl:when test="contains($tekst,'&#x9;')">
                <xsl:value-of select="substring-before($tekst,'&#x9;')"></xsl:value-of>
                &#xa0;&#xa0;&#xa0;
                <xsl:call-template name="tabulacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="substring-after($tekst,'&#x9;')"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$tekst"></xsl:value-of>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="formatowanie">
        <xsl:param name="tekst"></xsl:param>
        <xsl:choose>
            <xsl:when test="contains($tekst,'&#xA;')">
                <xsl:call-template name="spacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="substring-before($tekst,'&#xA;')"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
                <br></br>
                <xsl:call-template name="formatowanie">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="substring-after($tekst,'&#xA;')"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="spacja">
                    <xsl:with-param name="tekst">
                        <xsl:value-of select="$tekst"></xsl:value-of>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
